%function replot
cartel1
pause(0.01);
axes( ...
    'Units','normalized', ...
    'visible','off', ...
    'YColor','w', ...
    'XColor','w', ...
    'Position',[0.20 0.05 0.8 0.8]);
if (projection == 2) projection_name='lambert'; end;
if (projection == 1) projection_name='mercator'; end;
if (GridGeodec == 1) GridGeodecision='on'; end;
if (GridGeodec == 2) GridGeodecision='off'; end;
if (color == 2) color_name='autumn'; end;
axesm( ...
    'MapProjection',projection_name, ...
    'MapLatLimit', [LATW LATE], ...
    'MapLonLimit', [LONW LONE], ...
    'Grid',GridGeodecision, ...
    'MLineLocation',GridGeoValue, ...
    'PLineLocation',GridGeoValue, ...
    'FontWeight','bold', ...
    'Frame','on', ...
    'MeridianLabel','on', ...
    'ParallelLabel','on');
data = load([direct coast]);
plotm(data(:,2),data(:,1),'-b','LineWidth',2);
%hold on
plotm(stalat,stalon, ...
                'rs', ...
                'LineWidth',2,...
                'MarkerEdgeColor','k',...
                'MarkerFaceColor','w',...
                'MarkerSize',6);
x=LONW:indib:LONE;
y=LATW:indib:LATE;
[XI,YI]=meshgrid(x,y);
ZI=griddata(res(:,1),res(:,2),res(:,3),XI,YI,'v4');
[c,h]=contourfm(YI,XI,ZI,0.1:isointer:10);
if (color == 1) color_name='spring'; end;
if (color == 2) color_name='autumn'; end;
if (color == 3) color_name='cool'; end;
if (color == 4) color_name='gray'; end;
if (color == 5) color_name='hot'; end;
if (color == 6) color_name='hsv'; end;
if (color == 7) color_name='jet'; end;
if (color == 8) color_name='pink'; end;
if (color == 9) color_name='prism'; end;
if (color == 10) color_name='summer'; end;
if (color == 11) color_name='white'; end;
colormap(color_name);
contourm(YI,XI,ZI,0.1:isointer:10,'color','k'); clabelm(c,h,'FontSize',13);
tightmap