%==========================================================================
% Programa para el clculo de la capacidad de localizacin de una red ssmica
%
% Este programa est optimizado para su uso con Matlab 7.0 y necesita la
% instalacin de Mapping Toolbox 2.0
% Juan Rueda y Julio Mezcua
% Instituto Geogrfico Nacional
% Agosto 2006
%==========================================================================
close all, clear, clc, echo off;
%====================================
% Inicio grficos y defino frame
oldFigNumber = watchon;
scrsz = get(0,'ScreenSize');
figNumber = figure;
set(1, ...
        'NumberTitle','off', ...
        'Name','LOCA 1.0               J. Rueda and J. Mezcua (2006)                           SEISMIC NETWORK LOCATION CAPABILITY', ...
        'Color',[1 1 1],...
        'backingstore','off',...
        'menubar','none',...
        'position',[1 25 scrsz(3) scrsz(4)-50]...
        );
axes ( ...
    'Units','normalized', ...
    'Position',[0.024 0.84 0.13 0.14]);

a=imread('nuevoescudo.jpg');
imagesc(a);
%axis square
axis off

kk = uicontrol(1,...
       'style','text',...
       'string','LOCA 1.0', ...
       'FontSize',25, ...
       'FontName','BankGothic Md BT', ...
       'Units','normalized', ...
       'BackGroundColor','w',...
       'foregroundcolor',[1,0,0],...
       'Position',[0. 0.78 0.19 0.06]);
kk = uicontrol(1,...
       'style','text',...
       'string','Seismic Network LOcation CApability Program',...
       'FontSize',12, ...
       'Units','normalized', ...
       'BackGroundColor','w',...
       'foregroundcolor',[0,0,0],...
       'Position',[0.01288 0.74 0.15824 0.06]);


kk = uicontrol(1,...
       'style','text',...
       'string','J. Rueda and J. Mezcua',...
       'Units','normalized', ...
       'FontSize',10, ...
       'BackGroundColor','w',...
       'foregroundcolor',[0,0,0],...
       'Position',[0.01288 0.66 0.15824 0.08]);

kk = uicontrol(1,...
       'style','text',...
       'string','jjrueda@fomento.es',...
       'Units','normalized', ...
       'FontSize',10, ...
       'FontAngle','italic', ...
       'BackGroundColor','w',...
       'foregroundcolor',[0,0,1],...
       'Position',[0.01288 0.64 0.15824 0.08]);
kk = uicontrol(1,...
       'style','text',...
       'string','jmezcua@fomento.es',...
       'Units','normalized', ...
       'FontSize',12, ...
       'FontSize',10, ...
       'FontAngle','italic', ...
       'BackGroundColor','w',...
       'foregroundcolor',[0,0,1],...
       'Position',[0.01288 0.62 0.15824 0.08]);    
%===================================================
kk=uicontrol(1,...
       'Style','frame', ...
       'Units','normalized', ...
       'BackGroundColor',[1,1,0.69],...
       'Position',[0.00184 0.01 0.18032 0.66]);
%===================================================
% variables por defecto
global sts inp_f tar_f direct LATE LONE LATW LONW t inter indib coast ma mb mc stations
global color isointer projection GridGeodec GridGeoValue
    sts='estaciones.dat'; inp_f='inp_final'; tar_f='tar_final';direct='C:\detect\';
    LATE=44; LONE=5; LATW=34; LONW=-10; t=0.7; inter=0.5; indib=0.1;    
    coast='spain.dat'; ma=1.17; mb=0.0012; mc=0.67; stations=4;
    color=1; isointer=0.2; projection=1; GridGeodec=1; GridGeoValue=5;
 
       
% boton directorio de trabajo
kk = uicontrol(1,...
       'style','text',...
       'string','Working Directory',...
       'BackGroundColor',[1,1,0.69],...
       'FontSize',10, ...
       'foregroundcolor','b',...
       'Units','normalized', ...
       'Position',[0.00368 0.635 0.17664 0.02]);
directo = uicontrol(1,...
       'Style','edit',...
       'String','C:\detect\',...
       'Units','normalized',...
       'BackGroundColor','w',...
       'Position',[0.0065 0.610 0.17 0.025],...
       'CallBack',[...
          'direct=get(directo,''String'');']);
      
% boton fichero de datos de las estaciones
kk = uicontrol(1,...
       'style','text',...
       'string','Stations File',...
       'BackGroundColor',[1,1,0.69],...
       'FontSize',10, ...
       'foregroundcolor','b',...
       'Units','normalized', ...
       'Position',[0.00368 0.585 0.17664 0.02]);
esta = uicontrol(1,...
       'Style','edit',...
       'String','estaciones.dat',...
       'Units','normalized',...
       'BackGroundColor','w',...
       'Position',[0.04048 0.56 0.10304 0.025],...
       'CallBack',[...
          'sts=get(esta,''String'');']);

% boton fichero de datos de la costa
kk = uicontrol(1,...
       'style','text',...
       'string','Coast File',...
       'BackGroundColor',[1,1,0.69],...
       'foregroundcolor','b',...
       'FontSize',10, ...
       'Units','normalized', ...
       'Position',[0.00368 0.535 0.17664 0.02]);
coast_1 = uicontrol(1,...
       'Style','edit',...
       'String','spain.dat',...
       'Units','normalized',...
       'BackGroundColor','w',...
       'Position',[0.04048 0.51 0.10304 0.025],...
       'CallBack',[...
          'coast=get(coast_1,''String'');']);
%Leo estaciones

% [stalon,stalat,stanoi,staname]=textread([direct sts],'%f%f%f%s');
% staname=char(staname);

% ZONA DE TRABAJO
% coordenadas del vrtice superior derecha
     
kk = uicontrol(1,...
       'style','text',...
       'string','Geographycal Zone',...
       'BackGroundColor',[1,1,0.69],...
       'foregroundcolor','b',...
       'FontSize',10, ...
       'Units','normalized', ...
       'Position',[0.00368 0.4775 0.17664 0.02]);
kk = uicontrol(1,...
        'style','text',...
        'string','N LAT',...
        'BackGroundColor',[1,1,0.69],...
        'foregroundcolor','b',...
        'Units','normalized', ...
        'Position',[0.10 0.45 0.04 0.02]);
     
ca_1 = uicontrol(1,...
        'Style','edit',...
        'String','44.0',...
        'Units','normalized', ...
        'BackGroundColor','w',...
        'Position',[0.135 0.4525 0.04 0.02],...
        'CallBack',[...
        	'LATE=str2num(get(ca_1,''String''));']); 

kk = uicontrol(1,...
        'style','text',...
        'string','E LON',...
        'BackGroundColor',[1,1,0.69],...
        'foregroundcolor','b',...
        'Units','normalized', ...
        'Position',[0.10 0.425 0.04 0.02]);
     
ca_2 = uicontrol(1,...
        'Style','edit',...
        'String','5.0',...
        'Units','normalized', ...
        'BackGroundColor','w',...
        'Position',[0.135 0.4275 0.04 0.02],...
        'CallBack',[...
        	'LONE=str2num(get(ca_2,''String''));']); 

% coordenadas del vrtice inferior izquierdo
     
kk = uicontrol(1,...
        'style','text',...
        'string','S LAT',...
        'BackGroundColor',[1,1,0.69],...
        'foregroundcolor','b',...
        'Units','normalized', ...
        'Position',[0.01 0.45 0.04 0.02]);
     
ca_3 = uicontrol(1,...
        'Style','edit',...
        'String','34.0',...
        'Units','normalized', ...
        'BackGroundColor','w',...
        'Position',[0.045 0.4525 0.04 0.02],...
        'CallBack',[...
        	'LATW=str2num(get(ca_3,''String''));']); 

kk = uicontrol(1,...
        'style','text',...
        'string','W LON',...
        'BackGroundColor',[1,1,0.69],...
        'foregroundcolor','b',...
        'Units','normalized', ...
        'Position',[0.01 0.425 0.04 0.02]);
     
ca_4 = uicontrol(1,...
        'Style','edit',...
        'String','-10.0',...
        'Units','normalized', ...
        'BackGroundColor','w',...
        'Position',[0.045 0.4275 0.04 0.02],...
        'CallBack',[...
        	'LONW=str2num(get(ca_4,''String''));']); 

%Formula de la magnitud        
    kk = uicontrol(1,...
       'style','text',...
       'string','Magnitude Formula',...
       'BackGroundColor',[1,1,0.69],...
       'foregroundcolor','b',...
       'FontSize',10, ...
       'Units','normalized', ...
       'Position',[0.00368 0.3950 0.17664 0.02]);
%===================================================
   kk = uicontrol(1,...
       'style','text',...
       'string','m = log (A/T) + a log R + b R + c',...
       'BackGroundColor',[1,1,0.69],...
       'foregroundcolor','r',...
       'FontName','Times', ...
       'FontAngle','italic', ...
       'FontSize',12, ...
       'Units','normalized', ...
       'Position',[0.00368 0.3750 0.17664 0.02]);

%Botones parmetros de la frmula
kk = uicontrol(1,...
        'style','text',...
        'string','a=',...
        'BackGroundColor',[1,1,0.69],...
        'FontName','Times', ...
        'FontAngle','italic', ...
        'FontSize',12, ...
        'foregroundcolor','b',...
        'Units','normalized', ...
        'Position',[0.01 0.345 0.01 0.02]);
     
ma_1 = uicontrol(1,...
        'Style','edit',...
        'String','1.17',...
        'Units','normalized', ...
        'BackGroundColor','w',...
        'Position',[0.025 0.3475 0.03 0.02],...
        'CallBack',[...
        	'ma=str2num(get(ma_1,''String''));']); 

kk = uicontrol(1,...
        'style','text',...
        'string','b',...
        'BackGroundColor',[1,1,0.69],...
        'FontName','Times', ...
        'FontAngle','italic', ...
        'FontSize',12, ...
        'foregroundcolor','b',...
        'Units','normalized', ...
        'Position',[0.065 0.345 0.01 0.02]);
     
mb_1 = uicontrol(1,...
        'Style','edit',...
        'String','0.0012',...
        'Units','normalized', ...
        'BackGroundColor','w',...
        'Position',[0.08 0.3475 0.04 0.02],...
        'CallBack',[...
        	'mb=str2num(get(mb_1,''String''));']);      
        
kk = uicontrol(1,...
        'style','text',...
        'string','c',...
        'BackGroundColor',[1,1,0.69],...
        'FontName','Times', ...
        'FontAngle','italic', ...
        'FontSize',12, ...
        'foregroundcolor','b',...
        'Units','normalized', ...
        'Position',[0.125 0.345 0.01 0.02]);
     
mc_1 = uicontrol(1,...
        'Style','edit',...
        'String','0.67',...
        'Units','normalized', ...
        'BackGroundColor','w',...
        'Position',[0.14 0.3475 0.03 0.02],...
        'CallBack',[...
        	'mc=str2num(get(mc_1,''String''));']);                  
%===================================================
%Parmetros
kk = uicontrol(1,...
       'style','text',...
       'string','Parameters',...
       'BackGroundColor',[1,1,0.69],...
       'foregroundcolor','b',...
       'FontSize',10, ...
       'Units','normalized', ...
       'Position',[0.00368 0.3125 0.17664 0.02]);
       
%Botn periodo
kk = uicontrol(1,...
        'style','text',...
        'string','Lg Period',...
        'BackGroundColor',[1,1,0.69],...
        'foregroundcolor','b',...
        'HorizontalAlignment','left', ...
        'Units','normalized', ...
        'Position',[0.01 0.285 0.04 0.02]);
     
te = uicontrol(1,...
        'Style','edit',...
        'String','0.7',...
        'Units','normalized', ...
        'BackGroundColor','w',...
        'Position',[0.055 0.2875 0.03 0.02],...
        'CallBack',[...
        	't=str2num(get(te,''String''));']); 

%===================================================
%Botn nmero de estaciones
kk = uicontrol(1,...
        'style','text',...
        'string','Stations',...
        'BackGroundColor',[1,1,0.69],...
        'foregroundcolor','b',...
        'HorizontalAlignment','left', ...
        'Units','normalized', ...
        'Position',[0.10 0.285 0.04 0.02]);
     
stations_1 = uicontrol(1,...
        'Style','edit',...
        'String','4',...
        'Units','normalized', ...
        'BackGroundColor','w',...
        'Position',[0.145 0.2875 0.03 0.02],...
        'CallBack',[...
        	'stations=str2num(get(stations_1,''String''));']); 

%===================================================
%Botn intervalo de clculo
kk = uicontrol(1,...
        'style','text',...
        'string','Grid',...
        'BackGroundColor',[1,1,0.69],...
        'HorizontalAlignment','left', ...
        'foregroundcolor','b',...
        'Units','normalized', ...
        'Position',[0.01 0.255 0.06 0.02]);
     
inter_1 = uicontrol(1,...
        'Style','edit',...
        'String','0.5',...
        'Units','normalized', ...
        'BackGroundColor','w',...
        'Position',[0.055 0.2575 0.03 0.02],...
        'CallBack',[...
        	'inter=str2num(get(inter_1,''String''));']); 

%===================================================
%OUTPUT
kk = uicontrol(1,...
       'style','text',...
       'string','OUTPUT',...
       'BackGroundColor',[1,1,0.69],...
       'foregroundcolor','b',...
       'FontSize',10, ...
       'Units','normalized', ...
       'Position',[0.00368 0.2225 0.17664 0.02]);
       
%Botn intervalo de dibujo
kk = uicontrol(1,...
        'style','text',...
        'string','Grid Plot',...
        'BackGroundColor',[1,1,0.69],...
        'HorizontalAlignment','left', ...
        'foregroundcolor','b',...
        'Units','normalized', ...
        'Position',[0.10 0.195 0.08 0.02]);
     
indib_1 = uicontrol(1,...
        'Style','edit',...
        'String','0.1',...
        'Units','normalized', ...
        'BackGroundColor','w',...
        'Position',[0.145 0.1975 0.03 0.02],...
        'CallBack',[...
        	'indib=str2num(get(indib_1,''String''));']); 

   % boton color
    
    kk = uicontrol(1,...
       'style','text',...
       'string','Color',...
       'foregroundcolor','b',...
       'BackGroundColor',[1,1,0.69],...
       'HorizontalAlignment','left', ...
       'Units','normalized', ...
       'Position',[0.01 0.195 0.05 0.02]);
    
    color_1 = uicontrol(1,...
       'Style','popup',...
       'String','spring|autumn|cool|gray|hot|hsv|jet|pink|prism|summer|white',...
       'Units','normalized', ...
       'BackGroundColor','w',...
       'Position',[0.035 0.1975 0.05 0.02],...
       'CallBack',[...
       	'color=(get(color_1,''value''));']);   
%===================================================
%Botn intervalo de isolineas
kk = uicontrol(1,...
        'style','text',...
        'string','IsoInter',...
        'BackGroundColor',[1,1,0.69],...
        'foregroundcolor','b',...
        'HorizontalAlignment','left', ...
        'Units','normalized', ...
        'Position',[0.01 0.165 0.04 0.02]);
     
isointer_1 = uicontrol(1,...
        'Style','edit',...
        'String','0.2',...
        'Units','normalized', ...
        'BackGroundColor','w',...
        'Position',[0.055 0.1675 0.03 0.02],...
        'CallBack',[...
        	'isointer=str2num(get(isointer_1,''String''));']); 
%=================================================
% boton proyeccin
    
    kk = uicontrol(1,...
       'style','text',...
       'string','Proj',...
       'foregroundcolor','b',...
       'BackGroundColor',[1,1,0.69],...
       'HorizontalAlignment','left', ...
       'Units','normalized', ...
       'Position',[0.10 0.165 0.05 0.02]);
    
    projection_1 = uicontrol(1,...
       'Style','popup',...
       'String','Mercator|Lambert',...
       'Units','normalized', ...
       'BackGroundColor','w',...
       'Position',[0.120 0.1675 0.055 0.02],...
       'CallBack',[...
       	'projection=(get(projection_1,''value''));']);   
    %=============================================
    
   % boton grid en el mapa
    
    kk = uicontrol(1,...
       'style','text',...
       'string','GridGeo',...
       'foregroundcolor','b',...
       'BackGroundColor',[1,1,0.69],...
       'HorizontalAlignment','left', ...
       'Units','normalized', ...
       'Position',[0.01 0.135 0.05 0.02]);
    
    GridGeodec_1 = uicontrol(1,...
       'Style','popup',...
       'String','yes|no',...
       'Units','normalized', ...
       'BackGroundColor','w',...
       'Position',[0.045 0.1375 0.035 0.02],...
       'CallBack',[...
       	'GridGeodec=(get(GridGeodec_1,''value''));']);   
%===================================================   
%Botn valor Grid en el mapa
kk = uicontrol(1,...
        'style','text',...
        'string','GridGeo',...
        'BackGroundColor',[1,1,0.69],...
        'HorizontalAlignment','left', ...
        'foregroundcolor','b',...
        'Units','normalized', ...
        'Position',[0.10 0.135 0.08 0.02]);
     
GridGeoValue_1 = uicontrol(1,...
        'Style','edit',...
        'String','5',...
        'Units','normalized', ...
        'BackGroundColor','w',...
        'Position',[0.145 0.1375 0.03 0.02],...
        'CallBack',[...
        	'GridGeoValue=str2num(get(GridGeoValue_1,''String''));']); 
    
% boton fichero de salida
    
kk = uicontrol(1,...
       'Style','push',...
       'string','Out File',...
       'Units','normalized', ...
       'position',[0.01 0.1075 0.05 0.02],...
       'callback',[...
          'salida']);
% =========================

% boton reiniciar
kk = uicontrol(1,...
       'Style','push',...
       'string','Out Plot',...
       'Units','normalized', ...
       'position',[0.125 0.1075 0.05 0.02],...
       'callback',[...
          'pinto']);    
    
kk = uicontrol(1,...
       'Style','push',...
       'string','PLOT NETWORK',...
       'BackGroundColor','r',...
       'foregroundcolor','r',...
       'Units','normalized', ...
       'position',[0.005 0.05 0.080 0.04],...
       'callback',[...
           'dibujored']);
       
% Calcular deteccin
    
kk = uicontrol(1,...
       'Style','push',...
       'string','CALCULATE',...
       'BackGroundColor','r',...
       'foregroundcolor','r',...
       'Units','normalized', ...
       'position',[0.091 0.05 0.0861 0.04],...
       'callback',[...
          'detec']);
      
% boton ayuda
    
% kk = uicontrol(1,...
%        'Style','push',...
%        'string','HELP',...
%        'Units','normalized', ...
%        'position',[0.058 0.015 0.05 0.03],...
%        'callback',[...
%           'web MANUAL.pdf']);
% =========================

% boton salir
    
kk = uicontrol(1,...
       'Style','push',...
       'string','EXIT',...
       'Units','normalized', ...
       'position',[0.01 0.015 0.05 0.03],...
       'callback',[...
          'quit']);
% =========================

% boton reiniciar
kk = uicontrol(1,...
       'Style','push',...
       'string','REPLOT',...
       'Units','normalized', ...
       'position',[0.125 0.015 0.05 0.03],...
       'callback',[...
          'replot']);
% =========================

