%function detec
%Leo estaciones

global sts inp_f tar_f direct LATE LONE LATW LONW t inter indib coast ma mb mc stations
global color isointer projection GridGeodec GridGeoValue

[stalon,stalat,stanoi,staname]=textread([direct sts],'%f%f%f%s');
staname=char(staname);
cartel
pause(0.01);
est=size(stalon);
lat_ori=LATW; lon_ori=LONW; lat_fin=LATE; lon_fin=LONE;
resultados=999*ones((lon_fin-lon_ori)/inter,(lat_fin-lat_ori)/inter);
res=999*ones((((lon_fin-lon_ori)/inter)*((lat_fin-lat_ori)/inter)),3);
origen=ones(est(1),2);
i=1; n=1;
for ori_lon = lon_ori: inter: lon_fin
    j=1;
    for ori_lat = lat_ori: inter: lat_fin
    ori(:,1)=origen(:,1)*ori_lat;
    ori(:,2)=origen(:,2)*ori_lon;
    dist=111.1774734*distance(ori(:,1), ori(:,2), stalat, stalon);
        for m = 7: -0.1: 0.1
        a=t*10.^(m-ma*log10(dist)-mb*(dist)-mc)*10^-6;
        adb=10*log10(a.^2);
        dife=adb-stanoi;
        signo=sign(dife);
        num=(est(1)+sum(signo))/2;
        if num > stations - 1
            resultados(i,j)= m;
            res(n,1)= ori_lon;
            res(n,2)= ori_lat;
            res(n,3)= m;
        end
        end
    j=j+1; n=n+1;
    end
    i=i+1;
end
axes( ...
    'Units','normalized', ...
    'visible','off', ...
    'YColor','w', ...
    'XColor','w', ...
    'Position',[0.20 0.05 0.8 0.8]);
if (projection == 2) projection_name='lambert'; end;
if (projection == 1) projection_name='mercator'; end;
if (GridGeodec == 1) GridGeodecision='on'; end;
if (GridGeodec == 2) GridGeodecision='off'; end;
if (color == 2) color_name='autumn'; end;
axesm( ...
    'MapProjection',projection_name, ...
    'MapLatLimit', [LATW LATE], ...
    'MapLonLimit', [LONW LONE], ...
    'Grid',GridGeodecision, ...
    'MLineLocation',GridGeoValue, ...
    'PLineLocation',GridGeoValue, ...
    'FontWeight','bold', ...
    'Frame','on', ...
    'MeridianLabel','on', ...
    'ParallelLabel','on');
data = load([direct coast]);
plotm(data(:,2),data(:,1),'-b','LineWidth',2);
%hold on
plotm(stalat,stalon, ...
                'rs', ...
                'LineWidth',2,...
                'MarkerEdgeColor','k',...
                'MarkerFaceColor','w',...
                'MarkerSize',6);
x=LONW:indib:LONE;
y=LATW:indib:LATE;
[XI,YI]=meshgrid(x,y);
ZI=griddata(res(:,1),res(:,2),res(:,3),XI,YI,'v4');
[c,h]=contourfm(YI,XI,ZI,0.1:isointer:10);
if (color == 1) color_name='spring'; end;
if (color == 2) color_name='autumn'; end;
if (color == 3) color_name='cool'; end;
if (color == 4) color_name='gray'; end;
if (color == 5) color_name='hot'; end;
if (color == 6) color_name='hsv'; end;
if (color == 7) color_name='jet'; end;
if (color == 8) color_name='pink'; end;
if (color == 9) color_name='prism'; end;
if (color == 10) color_name='summer'; end;
if (color == 11) color_name='white'; end;
colormap(color_name);
contourm(YI,XI,ZI,0.1:isointer:10,'color','k'); clabelm(c,h,'FontSize',13);
tightmap


